;;; Sierra Script 1.0 - (do not remove this comment)
; Tetris
(script# 1)
(include sci.sh)
(include game.sh)
(use main)
(use controls)
(use cycle)
(use game)
(use feature)
(use obj)
(use inv)
(use door)
(use jump)
(use dpath)

(public
	rm001 0
)

(local
	HEIGHT = 20
	WIDTH = 10
	[field 200] ; default value is zero
	[figures 28] = [1 3 5 7 ; I
					2 4 5 7 ; Z
					3 5 4 6 ; S
					3 5 4 7 ; T
					2 3 5 7 ; L
					3 5 7 6 ; J
					2 3 4 5 ; O
				   ]
	[ax 4]
	[bx 4]
	[ay 4]
	[by 4]
	[nx 4]
	[ny 4]
	
	dx = 0
	rotate = 0
	colorNum = 1
	n = 0
	delay = 30

	[displayString 80]
	
	offsetx = 119
	offsety = 12
	
	elapsedTime = 0
	lastFrameTime = 0
	
	next = 0
	
	clear = 0
	cleared = 0
)


(instance block0 of Prop
	(properties
		view 000
		x -10
		y -10
		loop 0
		cel 0
		priority 15
	)
)
(instance block1 of Prop
	(properties
		view 000
		x -10
		y -10
		loop 0
		cel 0
		priority 15
	)
)
(instance block2 of Prop
	(properties
		view 000
		x -10
		y -10
		loop 0
		cel 0
		priority 15
	)
)
(instance block3 of Prop
	(properties
		view 000
		x -10
		y -10
		loop 0
		cel 0
		priority 15
	)
)

(instance block4 of View
	(properties
		view 000
		x -10
		y -10
		loop 0
		cel 0
		priority 15
	)
)

(instance rosella of Act
	(properties
		view 004
		x 260
		y 165
		loop 1
		priority 15
	)
)


(instance rm001 of Rm
	(properties
		picture scriptNumber
	)
	
	(method (init &tmp i)
		(super init:)
		(self setScript: RoomScript)
	
	    (block0 init:)		
	    (block1 init:)		
	    (block2 init:)		
	    (block3 init:)
	    
	    ;; todo: encapsulate this in a procedure
	    (= next (Random 0 6))
	    (= n (Random 0 6))
		(for ((= i 0)) (< i 4) ((++ i)) 
			(= [ax i] (mod [figures (+ i (* n 4))] 2))
	    	(= [ay i] (/   [figures (+ i (* n 4))] 2))
	    	(+= [ax i] 4) ; move it to the centre
		)	
		(= next (Random 0 6))
		(for ((= i 0)) (< i 4) ((++ i)) 
			(= [nx i] (mod [figures (+ i (* next 4))] 2))
	    	(= [ny i] (/   [figures (+ i (* next 4))] 2))
		)	
		
		(= gSpeed 1)
		(= lastFrameTime (GetTime))
		
		(gTheMusic prevSignal: 0  stop: number: 100 loop: -1 play:)
		(rosella init: setCycle: Fwd cycleSpeed: 10)
	)
)

(procedure (check &tmp i [tempString 500]) ; checks for collision returns 1 if true
	(for ((= i 0)) (< i 4) ((++ i))
		(if 
			(or (< [ax i] 0) ; left side check 0
				(>= [ax i] WIDTH) ; right side check
				(>= [ay i] HEIGHT)
			)
			(return 1)
		else
			(if [field (+ [ax i] (* [ay i] WIDTH))] 
				(if (== [ay i] 1)
					((ScriptID DYING_SCRIPT) caller: 800)
					(gGame setScript: (ScriptID DYING_SCRIPT))
				)
				(return 1) ; check with field
			)
		)
	)
	(return 0)	; no collision
)
	
(procedure (refresh)
	; 10 lines cleared, level up!
	(if (> clear (* gLevel 10))
		(++ gLevel)
		(= clear 0)
		(rosella cycleSpeed: (- 10 gLevel))
		(SL doit:)
	)

	(DrawPic gRoomNumber)
	(Display {Tetris} dsCOORD 206 12 dsCOLOUR clWHITE dsFONT 100)
	(Display {Tetris} dsCOORD 205 11 dsCOLOUR clBLACK dsFONT 100)
	(Display {Tetris} dsCOORD 204 10 dsCOLOUR clMAROON dsFONT 100)
	(Display "Controls:" dsFONT 4 dsCOLOR clSILVER dsCOORD 205 40)
	(Display "____W____Rotate" dsFONT 4 dsCOLOR clSILVER dsCOORD 205 50)
	(Display "__A___D__Move Left/Right" dsFONT 4 dsCOLOR clSILVER dsCOORD 205 60)
	(Display "____S____Move Down" dsFONT 4 dsCOLOR clSILVER dsCOORD 205 70)
	
	(Display {Score:} dsFONT 4 dsCOLOR clBLACK dsCOORD 21 11)
	(Display {Score:} dsFONT 4 dsCOLOR clSILVER dsCOORD 20 10)
	(Format @displayString {%d} gScore)
	(Display @displayString dsFONT 100 dsCOLOR clBLACK dsCOORD 21 21 dsALIGN alRIGHT dsWIDTH 90)
	(Display @displayString dsFONT 100 dsCOLOR clWHITE dsCOORD 20 20 dsALIGN alRIGHT dsWIDTH 90)
	
	(Display {Highest:} dsFONT 4 dsCOLOR clBLACK dsCOORD 21 41)
	(Display {Highest:} dsFONT 4 dsCOLOR clSILVER dsCOORD 20 40)
	(Format @displayString {%d} gMaxScore)
	(Display @displayString dsFONT 100 dsCOLOR clBLACK dsCOORD 21 51 dsALIGN alRIGHT dsWIDTH 90)
	(Display @displayString dsFONT 100 dsCOLOR clWHITE dsCOORD 20 50 dsALIGN alRIGHT dsWIDTH 90)
	
	(Display {Next:} dsFONT 4 dsCOLOR clBLACK dsCOORD 21 96)
	(Display {Next:} dsFONT 4 dsCOLOR clSILVER dsCOORD 20 95)
	
	(Display {Lines Cleared:} dsFONT 4 dsCOLOR clBLACK dsCOORD 206 96)
	(Display {Lines Cleared:} dsFONT 4 dsCOLOR clSILVER dsCOORD 205 95)
	(Format @displayString {%d} cleared)
	(Display @displayString dsCOLOR clBLACK dsCOORD 206 96 dsALIGN alRIGHT dsWIDTH 90)
	(Display @displayString dsCOLOR clWHITE dsCOORD 205 95 dsALIGN alRIGHT dsWIDTH 90)
)


(instance RoomScript of Script
	(properties)
	
	(method (handleEvent pEvent)
	    (switch (pEvent type?) 
	      	(evKEYBOARD
	        	(if (== (pEvent message?) KEY_w)
	        		(= rotate 1)
	              	(pEvent claimed: 1)
				)
				(if (== (pEvent message?) KEY_a)
	        		(= dx -1)
	              	(pEvent claimed: 1)
				)
				(if (== (pEvent message?) KEY_d)
	        		(= dx 1)
	              	(pEvent claimed: 1)
				)
				(if (== (pEvent message?) KEY_s)
	        		(= delay 1)
	              	(pEvent claimed: 1)
				)
			)
		)
	)

	(method (doit &tmp i cx cy x y j row count)
		;;; timer stuff ;;;
		(= elapsedTime (- (GetTime) lastFrameTime))
		;(Format @displayString "elapsed: %d" elapsedTime )
	    ;(Display @displayString dsCOORD 160 20 dsCOLOUR clRED dsFONT 999)
		
		;;;; move ;;;;
		(for ((= i 0)) (< i 4) ((++ i)) 
			(= [bx i] [ax i]) ; store previous position
			(= [by i] [ay i])
			(+= [ax i] dx) ; move left or right
		)
		(if (check) ; stop and move back to previous position
			(for ((= i 0)) (< i 4) ((++ i))
				(= [ax i] [bx i])
				(= [ay i] [by i])
			)
			
		)
		
		
		;;;; rotate ;;;;
		(if rotate
			(= cx [ax 1]) ; center of rotation
			(= cy [ay 1]) 
			(for ((= i 0)) (< i 4) ((++ i)) ; rotate the blocks
				(= x (- [ay i] cy))
				(= y (- [ax i] cx))
				(= [ax i] (- cx x))
				(= [ay i] (+ cy y))
			)
			(if (check) ; can't rotate this way, move back to previous
				(for ((= i 0)) (< i 4) ((++ i))
					(= [ax i] [bx i])
					(= [ay i] [by i])
				)
			)		
		)
		
		;;;; tick ;;;;
		(if (> elapsedTime delay)
			(= lastFrameTime (GetTime))
			(for ((= i 0)) (< i 4) ((++ i)) 
				(= [bx i] [ax i]) ; store previous position
				(= [by i] [ay i])
				(++ [ay i]) ; move down one block
			)
			(if (check) ; did we hit something?
				(for ((= i 0)) (< i 4) ((++ i)) 
					;(FormatPrint {x: %d y: %d index: %d} [bx i] [by i] (+ [bx i] (* [by i] WIDTH)))
					(= [field (+ [bx i] (* [by i] WIDTH))] colorNum) 
				)
				(= colorNum (Random 1 6))
				(= n next)
				(= next (Random 0 6))
				(for ((= i 0)) (< i 4) ((++ i)) 
					(= [ax i] (mod [figures (+ i (* n 4))] 2))
		    		(= [ay i] (/   [figures (+ i (* n 4))] 2))
		    		(+= [ax i] 4) ; move it to the centre
				)
				
				(for ((= i 0)) (< i 4) ((++ i)) 
					(= [nx i] (mod [figures (+ i (* next 4))] 2))
		    		(= [ny i] (/   [figures (+ i (* next 4))] 2))
				)
			)
		)
		
		;;;; check lines ;;;;
		(= row (- HEIGHT 1))
		(for ((= i (- HEIGHT 1))) (> i 0) ((-- i))
			(= count 0)
			(for ((= j 0)) (< j WIDTH) ((++ j))
				(if [field (+ j (* i WIDTH))]
					(++ count)
				)
				(= 
					[field (+ j (* row WIDTH))] 
					[field (+ j (* i WIDTH))]
				)
			)
			(if (< count WIDTH)
				(-- row)
				(refresh) ; clear the screen
			)
		)
		(+= clear row) ; cleared this level
		(+= cleared row) ; cleared in total
		(switch row
			(4 (+= gScore (* 1200 gLevel)))
			(3 (+= gScore (* 300 gLevel)))
			(2 (+= gScore (* 100 gLevel)))
			(1 (+= gScore (* 40 gLevel)))
		)

		;(Format @displayString "Row: %d" row )
	    ;(Display @displayString dsCOORD 250 180 dsCOLOUR clRED dsFONT 4)
		
		(= dx 0)
		(= rotate 0)
		(= delay (- 33 (* gLevel 3)))
		
	    ;;;; draw the set blocks ;;;;
	    (for ((= i 0)) (< i HEIGHT) ((++ i))
	    	(for ((= j 0)) (< j WIDTH) ((++ j))	
	    		;(Format @displayString "X" )
	    		;(Display @displayString dsCOORD (* j 8) (* i 8) dsCOLOUR clRED dsFONT 4)
	    		(if [field (+ j (* i WIDTH))] 
	    			(block4 init: loop: [field (+ j (* i WIDTH))] posn: (+ offsetx (* j 8)) (+ offsety (* i 8)))
	    			(gAddToPics add: block4 eachElementDo: #init doit:)
				)
			)
		)
	    
	    (block0 loop: colorNum posn: (+ offsetx (* [ax 0] 8)) (+ offsety (* [ay 0] 8)))
	    (block1 loop: colorNum posn: (+ offsetx (* [ax 1] 8)) (+ offsety (* [ay 1] 8)))
	    (block2 loop: colorNum posn: (+ offsetx (* [ax 2] 8)) (+ offsety (* [ay 2] 8)))
	    (block3 loop: colorNum posn: (+ offsetx (* [ax 3] 8)) (+ offsety (* [ay 3] 8)))
	    
	    (block4 init: colorNum posn: (+ 50 (* [nx 0] 8)) (+ 110 (* [ny 0] 8)))
	    (gAddToPics add: block4 eachElementDo: #init doit:)
	    (block4 init: colorNum posn: (+ 50 (* [nx 1] 8)) (+ 110 (* [ny 1] 8)))
	    (gAddToPics add: block4 eachElementDo: #init doit:)
	    (block4 init: colorNum posn: (+ 50 (* [nx 2] 8)) (+ 110 (* [ny 2] 8)))
	    (gAddToPics add: block4 eachElementDo: #init doit:)
	    (block4 init: colorNum posn: (+ 50 (* [nx 3] 8)) (+ 110 (* [ny 3] 8)))
	    (gAddToPics add: block4 eachElementDo: #init doit:)

	    
	    
	    (super doit:)
	)
)
